/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.payment.action;

import java.io.Serializable;
import java.util.Comparator;

import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.payroll.base.PayrollAction;
import jp.mosp.payroll.dao.CmCityDao;
import jp.mosp.payroll.dto.CmCityDto;
import jp.mosp.payroll.payment.vo.CityListVo;

public class CityListAction  extends PayrollAction {
	// R}h
	private static final String CMD_CITY_SET_LIST_SHOW      = "U5260";	// \
	private static final String CMD_CITY_SET_LIST_SELECT    = "U5261";	// 
	private static final String CMD_CITY_SET_LIST_RE_SEARCH = "U5262";	// Č
	private static final String CMD_STATION_TYPE_LIST_SORT    = "U5263";	// \[g

	/**
	 * Action̏sB<br><br>
	 * ȉ̏sB
	 * <ul><li>
	 * {@link PayrollAction#PayrollAction()}
	 * </li></ul>
	 */
	public CityListAction() {
		super();
	}

	/* (non-Javadoc)
	 * @see jp.mosp.common.common.BaseAction#getSpecificVo()
	 */
	@Override
	protected BaseVo getSpecificVo() {
		return new CityListVo();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// PAYROLLmF
		confirmPayrollAuth();
		// VO擾yѐݒ
		prepareVo();
		CityListVo vo = (CityListVo)getVo();
		// ЋsR[h擾
		vo.aryPltCoBankCode = getCoBankArray();
		// R}h̏
		if (cmd.equals(CMD_CITY_SET_LIST_SHOW)) {
			// \
			vo.setFormerKey(vo.KEY_CITY_CODE);
			vo.setIsAscending(true);
			// lɃZbg	
			vo.setSearchmode(CityListVo.SEARCH_OFF);
		} else if (cmd.equals(CMD_CITY_SET_LIST_SELECT)) {
			// 
			vo.setParams(request);
			searchCityList(vo);
			vo.setFormerKey(vo.KEY_CITY_CODE);
			vo.setIsAscending(true);
			vo.initListInfo();
			// ɃZbg
			vo.setSearchmode(CityListVo.SEARCH_ON);
		} else if (cmd.equals(CMD_CITY_SET_LIST_RE_SEARCH)) {
			// Č
			if(vo.getSearchmode() == CityListVo.SEARCH_ON){
				session.removeAttribute(MospConst.ATT_DTO);
				searchCityList(vo);
				vo.setPageButton();
				sortList(vo);	
			}
		} else if (cmd.equals(CMD_STATION_TYPE_LIST_SORT)) {
			// \[g
			sortList(key1, vo);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	/**
	 * אݒ胊Xg
	 * @param vo CodeListVoCX^X
	 * @throws Exception
	 */
	private void searchCityList(CityListVo vo) throws Exception {
		// DBRlNV̎擾
		getConnection();
		// 
		CmCityDao dao = new CmCityDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		vo.setFields(
				dao.findForCondition(
					  vo.getTxtCityCode()
					, vo.getTxtCityName()
					, vo.getTxtCityKana()
					, vo.getTxtDesignatedNumber()
					, vo.getPltCoBankCode()
				)
		);
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getAryCityCode().length == 0) {
			vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_NO_DATA, ""));
		}
	}


	/**
	 * \[g
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private void sortList(String key, CityListVo vo) throws MospException {
		vo.sortList(key, getComparator(key, vo));
		vo.setFields(vo.getList());
	}
	
	/**
	 * \[g(VÕL[Ń\[g)
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private void sortList(CityListVo vo) throws MospException {
		vo.sortList(getComparator(vo.getFormerKey(), vo));
		vo.setFields(vo.getList());
	}
			
	/**
	 * rNX擾
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private Comparator<Object> getComparator(String key, CityListVo vo) throws MospException {
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_CITY_CODE)) {
			comp = new CompCityCode();
		} else if (key.equals(vo.KEY_CITY_NAME)) {
			comp = new CompCityName();
		} else if (key.equals(vo.KEY_CITY_KANA)) {
			comp = new CompCityKana();
		} else if (key.equals(vo.KEY_DESIGNATED_NUMBER)) {
			comp = new CompDesignatedNumber();
		} else if (key.equals(vo.KEY_CO_BANK_CODE)) {
			comp = new CompCoBankCode();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}
	
	
	
	/**
	 * s撬R[hɂrNX
	 */
	protected static class CompCityCode implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = 1030377205315377L;
		public int compare(Object obj1, Object obj2) {
			CmCityDto dto1 = (CmCityDto)obj1;
			CmCityDto dto2 = (CmCityDto)obj2;
			return dto1.getCityCode().compareTo(dto2.getCityCode());
		}
	}
	
	/**
	 * s撬ɂrNX
	 */
	protected static class CompCityName implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = 1030377205315377L;
		public int compare(Object obj1, Object obj2) {
			CmCityDto dto1 = (CmCityDto)obj1;
			CmCityDto dto2 = (CmCityDto)obj2;
			return dto1.getCityName().compareTo(dto2.getCityName());
		}
	}

	/**
	 * s撬JiɂrNX
	 */
	protected static class CompCityKana implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = 1030377205315377L;
		public int compare(Object obj1, Object obj2) {
			CmCityDto dto1 = (CmCityDto)obj1;
			CmCityDto dto2 = (CmCityDto)obj2;
			return dto1.getCityKana().compareTo(dto2.getCityKana());
		}
	}
		
	/**
	 * wԍɂrNX
	 */
	protected static class CompDesignatedNumber implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = 1030377205315377L;
		public int compare(Object obj1, Object obj2) {
			CmCityDto dto1 = (CmCityDto)obj1;
			CmCityDto dto2 = (CmCityDto)obj2;
			return dto1.getDesignatedNumber().compareTo(dto2.getDesignatedNumber());
		}
	}
		
	/**
	 * ЋsR[hɂrNX
	 */
	protected static class CompCoBankCode implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = 1030377205315377L;
		public int compare(Object obj1, Object obj2) {
			CmCityDto dto1 = (CmCityDto)obj1;
			CmCityDto dto2 = (CmCityDto)obj2;
			return dto1.getCoBankCode().compareTo(dto2.getCoBankCode());
		}
	}
}
